/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

#ifndef XWDMUSB_H_INCLUDED
#define XWDMUSB_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define USB_DEVICE_NAME        "bestxusb"

#define MY_FILE_DEVICE_USB  0x8000   /* 32768-65535 for customers */
#define MY_USB_IOCTL_INDEX  0x0800   /* 2048-4095   for customers */

/* Define our own private IOCTLs */

#define IOCTL_USB_CONNECT    CTL_CODE (MY_FILE_DEVICE_USB, \
                                       MY_USB_IOCTL_INDEX, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

#define IOCTL_USB_DISCONNECT CTL_CODE (MY_FILE_DEVICE_USB,     \
                                       MY_USB_IOCTL_INDEX + 1, \
                                         METHOD_BUFFERED,         \
                                         FILE_ANY_ACCESS)

#define IOCTL_USB_ISCONNECTED CTL_CODE (MY_FILE_DEVICE_USB,    \
                                       MY_USB_IOCTL_INDEX + 2, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

#define IOCTL_USB_ISDISCONNECTED CTL_CODE (MY_FILE_DEVICE_USB, \
                                       MY_USB_IOCTL_INDEX + 3, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS) 


#ifdef __cplusplus
}
#endif


#endif  /* _INC_BX_WDMUSB */

/* end of file */
